<?php
/**
 * GDF Assets
 *
 * Handles the theme assets for the frontend.
 *
 * @author   AyeCode
 * @package  GDF/Core
 * @since    2.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GDF_Assets {

	public static function init(){
		add_action( 'wp_enqueue_scripts', array(__CLASS__,'styles') );
		add_action( 'wp_enqueue_scripts', array(__CLASS__,'scripts') );
	}
	
	public static function styles(){
		
		// register
		wp_register_style( 'gdf-css', get_template_directory_uri() . '/assets/css/style.css', array(), GDF_VERSION );
		wp_register_style( 'gdf-mmenu-css', get_template_directory_uri() . '/assets/css/jquery.mmenu.css', array(), GDF_VERSION );
		wp_register_style( 'gdf-mmenu-pos-css', get_template_directory_uri() . '/assets/css/jquery.mmenu.positioning.css', array(), GDF_VERSION );

		// enqueue
		wp_enqueue_style( 'gdf-css' );
		wp_enqueue_style( 'gdf-mmenu-css' );
		wp_enqueue_style( 'gdf-mmenu-pos-css' );
		// comment reply script for threaded comments
		if ( is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		// custom
		$custom_css = get_option('gdf_css');
		if($custom_css){
			wp_add_inline_style( 'gdf-css', $custom_css );
		}

	}

	public static function scripts(){

		// register
		wp_register_script( 'gdf-js', get_template_directory_uri() . '/assets/js/scripts.js', array( 'jquery' ), GDF_VERSION, true );
		wp_register_script( 'gdf-mmenu-js', get_template_directory_uri() . '/assets/js/jquery.mmenu.min.js', array( 'jquery' ), GDF_VERSION, true );

		// enqueue
		wp_enqueue_script( 'gdf-js' );
		wp_enqueue_script( 'gdf-mmenu-js' );
	}

}
GDF_Assets::init();